<?php
session_start();

// Generate a random alphanumeric string
$captcha_code = substr(str_shuffle("0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"), 0, 6);

// Store the generated code in a session variable
$_SESSION['captcha_code'] = $captcha_code;

// Create an image
$image = imagecreate(100, 40);  // Width: 100, Height: 40
$background_color = imagecolorallocate($image, 255, 255, 255);  // White background
$text_color = imagecolorallocate($image, 0, 0, 0);  // Black text

// Add the CAPTCHA code to the image
imagestring($image, 5, 15, 10, $captcha_code, $text_color);

// Output the image as a PNG
header("Content-Type: image/png");
imagepng($image);

// Free up resources
imagedestroy($image);
?>
