<?php
session_start();

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Check if CAPTCHA matches
    if ($_POST['captcha_input'] == $_SESSION['captcha_code']) {
       
       require('phpmailer/class.phpmailer.php');

header('refresh: 10; url=https://woodstockshenandoahvirginialaws.co');

// Include the form for response display
include("sris.html");

date_default_timezone_set('America/New_York');



// Rest of your form processing logic
$tz = new DateTimeZone('America/New_York');
$date_ = new DateTime($_POST["date"]);
$time_ = new DateTime($_POST["time"]);
$date_->setTimezone($tz);
$time_->setTimezone($tz);
$time = $date = $date_->format('Y-n-j') . " " . $time_->format('H:i:s');

// Receiving variables
$_firstName = addslashes($_POST['_firstName']);
$_email = addslashes($_POST['_email']);
$_newPhone = addslashes($_POST['_newPhone']);
$_location = addslashes($_POST['_location']);

$fone_splitter = str_split($_newPhone);
$_areaCode = $fone_splitter[0] . $fone_splitter[1] . $fone_splitter[2]; 
$_prefix = $fone_splitter[3] . $fone_splitter[4] . $fone_splitter[5];
$_phdigits = $fone_splitter[6] . $fone_splitter[7] . $fone_splitter[8] . $fone_splitter[9];
$_message = addslashes($_POST['_message']);
$client_ip_addr = $_SERVER["REMOTE_ADDR"];
$Category = $_POST["Category"];
$ref_url = $_SERVER["HTTP_REFERER"];

// IP Address block
$banned_ips = [
    '82.147.85.76', '82.147.85.75', '82.147.85.79', 
    '82.147.85.98', '82.147.85.96', '82.147.85.157', 
    '82.147.85.158', '45.132.194.20', '196.196.53.136',
    // Add more IPs as needed
];

if (in_array($client_ip_addr, $banned_ips)) {
    echo("<p align='center'><b><font face='Arial' size='2' color='#0000FF'>IP Blocked</font></b></p>");
    exit; 
}

// Validation (adjust your validation rules here)
if (strlen($_newPhone) != 10) {
    echo("<p align='center'><b><font face='Arial' size='2' color='#0000FF'>Phone Number must contain 10 digits only!</font></b></p>");
    exit;
}

if (strlen($_firstName) <= 1) {
    die("<p align='center'><font face='Arial' size='3' color='#FF0000'>Please provide your First Name</font></p>");
}

if (!filter_var($_email, FILTER_VALIDATE_EMAIL)) {
    die("<p align='center'><font face='Arial' size='3' color='#FF0000'>Please enter a valid Email Address</font></p>");
}

if (!is_numeric($_areaCode) || strlen($_areaCode) != 3) {
    die("<p align='center'><font face='Arial' size='3' color='#FF0000'>Invalid Area Code! Only 3 digits allowed.</font></p>");
}

if (!is_numeric($_prefix) || strlen($_prefix) != 3) {
    die("<p align='center'><font face='Arial' size='3' color='#FF0000'>Invalid Prefix! Only 3 digits allowed.</font></p>");
}

if (!is_numeric($_phdigits) || strlen($_phdigits) != 4) {
    die("<p align='center'><font face='Arial' size='3' color='#FF0000'>Invalid Phone Number - Last 4 digits!</font></p>");
}

// Concatenate phone number
$_phone = $_areaCode . "-" . $_prefix . "-" . $_phdigits;

// Message validation
if (strlen($_message) > 250) {
    echo("<p align='center'><b><font face='Arial' size='2' color='#0000FF'>Message too long. Max 250 characters allowed.</font></b></p>");
    exit;
}

// Handle category validation
$category_names = [
    1 => "Traffic Laws",
    2 => "Criminal Defense Laws",
    3 => "Divorce Laws",
    4 => "Child Custody Laws",
    5 => "Personal Injury Laws"
];

if (!isset($category_names[$Category])) {
    die("<p align='center'><font face='Arial' size='3' color='#FF0000'>Choose a valid category option.</font></p>");
}
$catg_name = $category_names[$Category];

// Send the data via cURL to an external API (example here)
$ReqJson = json_encode([
    "ReceivedOn" => date("Y-m-d"),
    "Name" => $_firstName,
    "Email" => $_email,
    "Phone" => $_newPhone,
    "Category" => $catg_name,
    "Location" => $_location,
    "SourceURL" => $ref_url,
    "Msg" => $_message,
    "LeadType" => "1",
    "IPAddress" => $client_ip_addr
]);

$curl = curl_init();
curl_setopt_array($curl, [
    CURLOPT_URL => 'https://crm4.srislaw.com/app/api/Enquiry/PostSalesLead',
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPHEADER => [
        'Authorization: 0DC49FC7-D65B-4264-BA25-FFF0C732CA3D',
        'Content-Type: application/json'
    ],
    CURLOPT_POSTFIELDS => $ReqJson
]);
$response = curl_exec($curl);
curl_close($curl);

echo("<p align='center'><b><font face='Arial' size='2' color='#0000FF'>Thank You. Form submitted successfully.</font></b></p>");


       
        // Continue with your form processing (e.g., send email, save to database)
    } else {
        echo '<script>alert("CAPTCHA verification failed. Please try again.")</script>';
        // Optionally, you can redirect the user back to the form with an error message

  echo'<script>window.location = "https://woodstockshenandoahvirginialaws.co";</script>';

    }
} else {
    echo "Invalid request method.";
     echo'<script>window.location = "https://woodstockshenandoahvirginialaws.co";</script>';
}
?>
